unit chapter3Q1_u;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants,
  System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Data.DB, Vcl.StdCtrls, Vcl.Grids,
  chapter3Q1_d,
  Vcl.DBGrids;

type
  TfrmPetersonGroup = class(TForm)
    DBGrid1: TDBGrid;
    btnList: TButton;
    btnMrFerreira: TButton;
    btnEnglish: TButton;
    btnCost: TButton;
    btnDiscount: TButton;
    btnFaltemeyer: TButton;
    procedure btnListClick(Sender: TObject);
    procedure btnMrFerreiraClick(Sender: TObject);
    procedure btnEnglishClick(Sender: TObject);
    procedure btnCostClick(Sender: TObject);
    procedure btnDiscountClick(Sender: TObject);
    procedure btnFaltemeyerClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmPetersonGroup: TfrmPetersonGroup;

implementation

{$R *.dfm}

procedure TfrmPetersonGroup.btnCostClick(Sender: TObject);
var
  sSqlQuery: String;
begin
  dmoBandB.qryQuery.SQL.Clear;
  sSqlQuery := 'SELECT Date, Category, Format(SellingPrice, "Currency") AS Selling_Price, Format((SellingPrice / 125 * 100), "Currency") AS Cost FROM tblOrders WHERE ClientNo = 1';
  dmoBandB.qryQuery.SQL.Text := sSqlQuery;
  dmoBandB.qryQuery.active := true;
end;



procedure TfrmPetersonGroup.btnDiscountClick(Sender: TObject);
var
  sSqlQuery: String;
begin
   dmoBandB.qryQuery.SQL.Clear;
  sSqlQuery := 'UPDATE tblOrders SET SellingPrice = (SellingPrice - 5) WHERE SellingPrice >= 30';
  dmoBandB.qryQuery.SQL.Text := sSqlQuery;
  dmoBandB.qryQuery.ExecSQL;
end;

procedure TfrmPetersonGroup.btnEnglishClick(Sender: TObject);
var
  sSqlQuery: String;
begin
  dmoBandB.qryQuery.SQL.Clear;
  sSqlQuery := 'DELETE * FROM tblClients WHERE Nationality = "English"';
  dmoBandB.qryQuery.SQL.Text := sSqlQuery;
  dmoBandB.qryQuery.ExecSQL;
end;

procedure TfrmPetersonGroup.btnFaltemeyerClick(Sender: TObject);
var
  sSqlQuery: String;
begin
  dmoBandB.qryQuery.SQL.Clear;
  sSqlQuery := 'INSERT INTO tblClients VALUES (22, "Mr", "Harald", "Faltemeyer", "7407185683074", False, "Swedish")';
  dmoBandB.qryQuery.SQL.Text := sSqlQuery;
  dmoBandB.qryQuery.ExecSQL;
end;

procedure TfrmPetersonGroup.btnListClick(Sender: TObject);
var
  sSqlQuery: String;
begin
  dmoBandB.qryQuery.SQL.Clear;
  sSqlQuery := 'SELECT * FROM tblClients ORDER BY Surname, FName';
  dmoBandB.qryQuery.SQL.Text := sSqlQuery;
  dmoBandB.qryQuery.active := true;
end;

procedure TfrmPetersonGroup.btnMrFerreiraClick(Sender: TObject);
var
  sSqlQuery: String;
begin
  dmoBandB.qryQuery.SQL.Clear;
  sSqlQuery :=
    'SELECT FORMAT(SUM(SellingPrice), "Currency") AS TotalDue FROM tblOrders WHERE ClientNo = 1';
  dmoBandB.qryQuery.SQL.Text := sSqlQuery;
  dmoBandB.qryQuery.active := true;
end;

end.
